package editor.wordcount;

import java.util.Iterator;

public interface WordCounter extends Iterable<WordCounterEntry> {
	public WordCounter makeCopy();
	public int get(String word);
	public void bump(String word);
	public void dock(String word);
	public Iterator<WordCounterEntry> iterator();
	public boolean isConsistent();
	
	default public void copyInto(WordCounter target) {
		for (WordCounterEntry entry: this) {
			for (int i = 0; i < entry.getCount(); i++) {
				target.bump(entry.getWord());
			}
		}
	}
	
	default public boolean isSorted() {
		WordCounterEntry prev = null;
		for (WordCounterEntry entry: this) {
			if (prev != null && entry.getWord().compareTo(prev.getWord()) < 0) {
				return false;
			}
			prev = entry;
		}
		return true;
	}
}
