package editor.wordcount;

public class WordCounterEntry {
	private String word;
	private int count;
	
	public WordCounterEntry(String word, int count) {
		this.word = word;
		this.count = count;
	}
	
	public void bump() {
		this.count += 1;
	}
	
	public void dock() {
		this.count = Math.max(this.count - 1, 0);
	}
	
	public int getCount() {
		return count;
	}
	
	public String getWord() {return word;}
	
	@Override
	public String toString() {return word + ":" + count;}
	
	@Override
	public boolean equals(Object other) {
		return this.toString().equals(other.toString());
	}
}
