package editor.wordcount;

import java.util.ArrayList;
import java.util.Iterator;


public class ChainedHashWordCounter implements WordCounter {
	private class WordCounterLink extends WordCounterEntry {
		public WordCounterLink(String word, int count, WordCounterLink next) {
			super(word, count);
			this.next = next;
		}

		WordCounterLink next;
	}
	
	private WordCounterLink[] table;
	private ArrayList<WordCounterEntry> entries;
	private final double MAX_LOAD = 0.75;
	
	public ChainedHashWordCounter() {
		this.table = new WordCounterLink[16];
		entries = new ArrayList<WordCounterEntry>();
	}
	
	@Override
	public int get(String word) {
		return 0;
	}

	@Override
	public void bump(String word) {
	}

	@Override
	public void dock(String word) {
	}

	@Override
	public Iterator<WordCounterEntry> iterator() {
		return this.entries.iterator();
	}

	public double getLoad() {
		return (double)entries.size() / table.length;
	}

	@Override
	public WordCounter makeCopy() {
		WordCounter copy = new ChainedHashWordCounter();
		this.copyInto(copy);
		return copy;
	}

	@Override
	public boolean isConsistent() {
		for (WordCounterEntry entry: this) {
			if (get(entry.getWord()) != entry.getCount()) {
				return false;
			}
		}
		return getLoad() < MAX_LOAD;
	}
}
