package maze;

import java.util.ArrayList;

public class PathHeap implements PathOrderer {
	private ArrayList<Path> heap;
	private Cell exit;
	
	public PathHeap(Cell exit) {
		heap = new ArrayList<>();
		this.exit = exit;
	}
	
	public PathHeap(PathHeap src) {
		this(src.exit);
		for (Path p: src.heap) {
			this.heap.add(p);
		}
	}
	
	public boolean isConsistent() {
		for (int i = 1; i < heap.size(); i++) {
			if (heap.get(i).totalDistanceTo(exit) < heap.get(parentOf(i)).totalDistanceTo(exit)) {
				return false;
			}
		}
		return true;
	}
	
	public static int leftOf(int i) {return -1;}
	public static int rightOf(int i) {return -1;}
	public static int parentOf(int i) {return -1;}

	@Override
	public void put(Path p) {
	}

	@Override
	public Path peek() {
		return heap.get(0);
	}

	@Override
	public Path remove() {
		return heap.remove(0);
	}

	@Override
	public boolean isEmpty() {
		return heap.size() == 0;
	}

}
