package maze;

import static org.junit.Assert.*;

import org.junit.Test;

public class MazeTest {
	
	Maze m;
	Solver s;
	
	public void testHeap() {
		s = new Solver(maze -> new PathHeap(maze.getExit()));
		System.out.println("PathHeap");
		solve();
	}
	
	public void testStack() {
		s = new Solver(maze -> new PathStack());
		System.out.println("PathStack");
		solve();
	}
	
	public void testQueue() {
		s = new Solver(maze -> new PathQueue());
		System.out.println("PathQueue");
		solve();
	}
	
	public void solve() {
		long start = System.nanoTime();
		s.findSolutionFor(m);
		long duration = System.nanoTime() - start;
		assertTrue(s.hasSolution());
		assertTrue(m.isValidPath(s.getSolution().getCells()));
		double sec = duration / Math.pow(10, 9);
		System.out.println("Duration: " + sec + " seconds");
		System.out.println("Enqueued: " + s.getEnqueued());
		System.out.println("Evaluated: " + s.getEvaluated());
	}
	
	public void test(int w, int h) {
		m = Maze.makeRandomized(w, h);
		testStack();
		testQueue();
		testHeap();
	}

	@Test
	public void smallTest() {
		test(300, 150);
	}
	
	@Test
	public void mediumTest() {
		test(600, 300);
	}
}
