package maze;

import java.util.HashSet;
import java.util.function.Function;

public class Solver {
	private Function<Maze,PathOrderer> constructor;
	private int enqueued, evaluated;
	private Path solution;
	
	public Solver(Function<Maze,PathOrderer> constructor) {
		this.constructor = constructor;
		this.enqueued = this.evaluated = 0;
		this.solution = null;
	}
	
	public boolean hasSolution() {
		return solution != null;
	}
	
	public Path getSolution() {
		return solution;
	}
	
	public int getEnqueued() {
		return enqueued;
	}
	
	public int getEvaluated() {
		return evaluated;
	}
	
	public void findSolutionFor(Maze m) {
		PathOrderer queue = constructor.apply(m);
		enqueued = evaluated = 0;
		queue.put(new Path(m.getEntry()));
		HashSet<Cell> visited = new HashSet<Cell>();
		// Your loop goes here.
		solution = queue.peek();
	}
}
