package editor.wordcount;

import java.util.Iterator;

import editor.wordcount.WordCounter;
import editor.wordcount.WordCounterEntry;

public class Trie implements WordCounter {
	private TrieListSorted children = new TrieListSorted();
	private int count = 0;
	private char c;
	private Trie parent;
	
	public Trie() {
		this('\0', null);
	}
	
	Trie(Trie src, Trie newParent) {
		this.c = src.c;
		this.count = src.count;
		this.parent = newParent;
		this.children = new TrieListSorted(src.children, newParent);
	}
	
	private Trie(char c, Trie parent) {
		this.c = c;
		this.parent = parent;
	}
	
	public char getChar() {return c;}
	
	@Override
	public int get(String key) {
		// Your solution here
		return 0;
	}
	
	@Override
	public void bump(String word) {
		// Your solution here
	}

	@Override
	public void dock(String word) {
		// Your solution here
	}

	@Override
	public Iterator<WordCounterEntry> iterator() {
		return new Iter();
	}
	
	private class Iter implements Iterator<WordCounterEntry> {

		@Override
		public boolean hasNext() {
			// Your solution here
			return false;
		}

		@Override
		public WordCounterEntry next() {
			// Your solution here
			return null;
		}
		
	}

	@Override
	public Trie makeCopy() {
		return new Trie(this, null);
	}

	@Override
	public boolean isConsistent() {
		for (Trie child: children) {
			if (child.parent != this) {
				return false;
			}
		}
		return isSorted();
	}
}
