package application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

import sorters.GnomeSorter;
import sorters.HeapSorter;
import sorters.InsertionSorter;
import sorters.MergeSorter;
import sorters.QuickSorter;
import sorters.Setting;
import sorters.Sorter;
import javafx.animation.AnimationTimer;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Ellipse;

public class Controller {
	ArrayList<Integer> nums;
	ArrayList<Ellipse> dots;
	double xOffset, yOffset;
	Queue<Setting<Integer>> updates = new LinkedList<>();
	
	private long FRAMES_PER_SEC = 50L;
	private long NANO_INTERVAL = 1000000000L / FRAMES_PER_SEC;
	
	private AnimationTimer timer = new AnimationTimer() {
		long last = 0;
		
		@Override
		public void handle(long now) {
			if (now - last > NANO_INTERVAL) {
				if (updates.isEmpty()) {
					timer.stop();
				} else {
					Setting<Integer> update = updates.remove();
					updateDot(update.getWhere(), update.getValue());
				}
				last = now;
			}
		}
		
	};
	
	@FXML
	Slider numDots;
	
	@FXML
	Pane panel;
	
	@FXML
	ChoiceBox<Sorter<Integer>> sorters;
	
	@FXML
	void initialize() {
		reset();
		sorters.getItems().add(new InsertionSorter<Integer>());
		sorters.getItems().add(new MergeSorter<Integer>());
		sorters.getItems().add(new QuickSorter<Integer>());
		sorters.getItems().add(new GnomeSorter<Integer>());
		sorters.getItems().add(new HeapSorter<Integer>());
		sorters.setValue(sorters.getItems().get(0));
	}
	
	@FXML
	void scramble() {
		Collections.shuffle(nums);
		resynchDots();
	}
	
	@FXML
	void sort() {
		Sorter<Integer> sorter = sorters.getValue();
		sorter.sort(nums);
		for (Setting<Integer> setting: sorter) {
			updates.add(setting);
		}
		timer.start();
	}

	@FXML
	void reset() {
		if (dots != null) {
			for (Ellipse dot: dots) {
				panel.getChildren().remove(dot);
			}
		}

		int size = (int)numDots.getValue();
		xOffset = panel.getWidth() / size;
		yOffset = panel.getHeight() / size;
		nums = new ArrayList<Integer>();
		dots = new ArrayList<Ellipse>();
		for (int i = 0; i < size; i++) {
			nums.add(i);
			Ellipse dot = new Ellipse(xOffset, yOffset);
			dot.setFill(Color.BLUE);
			panel.getChildren().add(dot);
			dot.setTranslateX(xOffset * i);
			dot.setTranslateY(yOffset * i);
			dots.add(dot);
		}
	}
	
	void resynchDots() {
		for (int i = 0; i < nums.size(); i++) {
			resynchDot(i);
		}
	}
	
	void update(int i, int newVal) {
		nums.set(i, newVal);
		resynchDot(i);
	}
	
	void updateDot(int i, int where) {
		dots.get(i).setTranslateY(yOffset * where);
	}
	
	void resynchDot(int i) {
		updateDot(i, nums.get(i));
	}
}
