package sorters;

import java.util.ArrayList;
import java.util.Iterator;

abstract public class Sorter<T extends Comparable<T>> implements Iterable<Setting<T>> {
	private ArrayList<Setting<T>> settings = new ArrayList<>();
	
	public void set(ArrayList<T> array, int i, T value) {
		settings.add(new Setting<T>(i, value));
		array.set(i, value);
	}
	
	public void swap(ArrayList<T> array, int i, int j) {
		T temp = array.get(i);
		set(array, i, array.get(j));
		set(array, j, temp);
	}
	
	@Override
	public Iterator<Setting<T>> iterator() {return settings.iterator();}
	
	public void sort(ArrayList<T> array) {
		settings = new ArrayList<>();
		sortAlgorithm(array);
	}
	
	abstract protected void sortAlgorithm(ArrayList<T> array);
	
	@Override
	public String toString() {
		String name = getClass().getName();
		return name.substring(name.lastIndexOf('.') + 1);
	}
}
