package numstack.model;

public interface IntStack {
	
	public int size();
	
	public void pop();

	public int peekBelow(int n);
	
	public void push(int c);
	
	default public boolean isEmpty() {
		return size() == 0;
	}
	
	default public int peek() {
		return peekBelow(0);
	}
	
	default public void popNotEmpty() {
		if (isEmpty()) {
			throw new IllegalStateException("Cannot pop empty stack");
		}
	}
	
	default public void peekInRange(int n) {
		if (n >= size()) {
			throw new IllegalArgumentException("Cannot peek below bottom of stack");
		}
		if (n < 0) {
			throw new IllegalArgumentException("Cannot peek above top of stack");
		}
	}
}
