package modeselection;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.IntPredicate;

import lejos.hardware.motor.NXTRegulatedMotor;

public class MotorFlagger<C extends Enum<C>> implements Flagger<C> {
	private NXTRegulatedMotor target;
	private ArrayList<C> flags = new ArrayList<>();
	private ArrayList<IntPredicate> preds = new ArrayList<>();
	
	public MotorFlagger(NXTRegulatedMotor target) {
		this.target = target;
	}
	
	public MotorFlagger<C> add(C flag, IntPredicate p) {
		flags.add(flag);
		preds.add(p);
		return this;
	}
	
	public MotorFlagger<C> add2(C trueFlag, C falseFlag, IntPredicate p) {
		add(trueFlag, p);
		add(falseFlag, i -> !p.test(i));
		return this;
	}
	
	@Override
	public void update(EnumSet<C> conditions) {
		int count = target.getTachoCount();
		for (int i = 0; i < flags.size(); i++) {
			if (preds.get(i).test(count)) {
				conditions.add(flags.get(i));
			}
		}
	}
	
	@Override
	public void log(Logger logger) {
		logger.format("Motor: %d", target.getTachoCount());
	}
}
