package modeselection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.DoublePredicate;
import java.util.function.Function;

import lejos.hardware.sensor.BaseSensor;
import lejos.robotics.SampleProvider;

public class SensorFlagger<C extends Enum<C>> extends BaseFlagger<C> implements Closeable {
	private BaseSensor sensor;
	private SampleProvider fetcher;
	private float[] values;
	private ArrayList<DoublePredicate> predicates = new ArrayList<>();
	
	public SensorFlagger(BaseSensor sensor) {
		this(sensor, s -> s);
	}
	
	public <S extends BaseSensor> SensorFlagger(S sensor, Function<S,SampleProvider> invocation) {
		this.sensor = sensor;
		this.fetcher = invocation.apply(sensor);
		values = new float[sensor.sampleSize()];
	}
	
	public SensorFlagger<C> add(C flag, DoublePredicate p) {
		flags.add(flag);
		predicates.add(p);
		return this;
	}
	
	public SensorFlagger<C> add2(C trueFlag, C falseFlag, DoublePredicate p) {
		return add(trueFlag, p)
		.add(falseFlag, d -> !p.test(d));
	}
	
	@Override
	public void update(EnumSet<C> conditions) {
		fetcher.fetchSample(values, 0);
		for (int i = 0; i < flags.size(); i++) {
			if (predicates.get(i).test(values[0])) {
				conditions.add(flags.get(i));
			}
		}
	}
	
	@Override
	public void log(Logger logger) {
		logger.format("%s: %5.2f", sensor.getName(), values[0]);
	}
	
	@Override
	public void close() throws IOException {
		sensor.close();
	}
}
