package modeselection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

import lejos.hardware.lcd.LCD;

public class StateClassifier<C extends Enum<C>> implements Closeable {
	private ArrayList<Flagger<C>> flaggers = new ArrayList<>();
	private ArrayList<Closeable> toClose = new ArrayList<>();
	private Class<C> conditionClass;
	
	public StateClassifier(Class<C> conditionClass) {
		this.conditionClass = conditionClass;
	}
	
	public StateClassifier<C> add(Flagger<C> flagger) {
		flaggers.add(flagger);
		if (flagger instanceof Closeable) {
			toClose.add((Closeable)flagger);
		}
		return this;
	}
	
	public int numPossibleStates() {
		return ConditionCounted.numCombos(flaggers);
	}
	
	public EnumSet<C> getCurrentState() {
		EnumSet<C> result = EnumSet.noneOf(conditionClass);
		for (Flagger<C> flagger: flaggers) {
			flagger.update(result);
		}
		return result;
	}

	@Override
	public void close() throws IOException {
		for (Closeable c: toClose) {
			c.close();
		}
	}
	
	public void logState(Logger logger, EnumSet<C> state) {
		logger.log("state:");
		for (C cond: state) {
			logger.log(cond.name());
		}
		for (Flagger<C> sensor: flaggers) {
			sensor.log(logger);
		}
	}
	
	public static <C extends Enum<C>> void showState(EnumSet<C> state, int row) {
		for (C cond: state) {
			LCD.drawString(cond.name(), 0, row++);
		}
	}
}
