package modeselection.vision;

import java.util.ArrayList;
import java.util.function.Predicate;

abstract public class BaseSubFlagger<C extends Enum<C>, D> implements SubFlagger<C> {
	protected ArrayList<C> flags = new ArrayList<>();
	protected ArrayList<Predicate<D>> preds = new ArrayList<>();

	public BaseSubFlagger() {}
	
	public BaseSubFlagger<C,D> add(C flag, Predicate<D> p) {
		flags.add(flag);
		preds.add(p);
		return this;
	}
	
	public BaseSubFlagger<C,D> add2(C trueFlag, C falseFlag, Predicate<D> p) {
		return add(trueFlag, p)
			  .add(falseFlag, d -> !p.test(d));
	}
	
	@Override
	public int numConditions() {
		return flags.size();
	}
}
