package modeselection.vision.color;

import java.util.EnumSet;

import lejos.hardware.video.YUYVImage;
import modeselection.Logger;
import modeselection.vision.BaseSubFlagger;

public class ColorCountFlagger<C extends Enum<C>> extends BaseSubFlagger<C,ColorCount> {
	private ColorFilter filter;
	private ColorCount count;
	
	public ColorCountFlagger(int uLo, int uHi, int vLo, int vHi) {
		filter = new ColorFilter(uLo, uHi, vLo, vHi);
	}

	@Override
	public void update(YUYVImage img, EnumSet<C> conditions) {
		count = new ColorCount(filter, img);
		for (int i = 0; i < flags.size(); i++) {
			if (preds.get(i).test(count)) {
				conditions.add(flags.get(i));
			}
		}
	}

	@Override
	public void log(Logger logger) {
		logger.log(String.format("ColorCount: count: %d densest(5): %d", count.getTotal(), count.densest(5)));
	}
}
