package modeselection.vision.config.color;

import lejos.hardware.video.YUYVImage;
import modeselection.vision.BitImage;
import modeselection.vision.color.ColorCount;
import modeselection.vision.color.ColorFilter;
import modeselection.vision.config.VisionBot;

public class ColorConcentrationViewer extends VisionBot {
	public static void main(String[] args) {
		new ColorConcentrationViewer(new ColorFilter(89, 103, 190, 213)).run(); // Banana
	}
	
	public ColorConcentrationViewer(ColorFilter model) {
		this.model = model;
	}
	
	private ColorFilter model;

	@Override
	public BitImage processImage(YUYVImage img) {
		ColorCount colors = new ColorCount(model, img);
		int best = colors.densest(5);
		BitImage result = new BitImage(img);
		for (int y = 0; y < img.getHeight(); y++) {
			result.set(best, y, true);
		} 
		return result;
	}

	@Override
	public void displayFinalInfo() {
		displayFrameRate(2);
	}
}
