package modeselection.vision;

import java.util.BitSet;

import lejos.hardware.lcd.LCD;
import lejos.hardware.video.YUYVImage;

public class BitImage {
	private BitSet img;
	private int width, height;
	
	public BitImage(int width, int height) {
		this.width = width;
		this.height = height;
		img = new BitSet(width * height);
	}
	
	public BitImage(YUYVImage src) {
		this(src.getWidth(), src.getHeight());
	}
	
	public static BitImage basicView(YUYVImage src) {
		int mean = src.getMeanY();
		BitImage img = new BitImage(src);
		for (int y = 0; y < img.getHeight(); y++) {
			for (int x = 0; x < img.getWidth(); x++) {
				img.set(x, y, (src.getY(x, y) & 0xFF) > mean);
			}
		}
		return img;
	}
	
	public static BitImage colorView(YUYVImage src, BiIntPredicate colors) {
		BitImage img = new BitImage(src);
		for (int y = 0; y < img.getHeight(); y++) {
			for (int x = 0; x < img.getWidth(); x+=2) {
				boolean match = colors.test(src.getU(x, y) & 0xFF, src.getV(x, y) & 0xFF);
				img.set(x, y, match);
				img.set(x+1, y, match);
			}
		}
		return img;
	}
	
	public BitImage(YUYVImage src, TriIntPredicate classifier) {
		this.width = src.getWidth();
		this.height = src.getHeight();
		img = new BitSet(width * height);
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				set(x, y, 
					classifier.test(src.getY(x, y) & 0xFF,
									src.getU(x, y) & 0xFF,
									src.getV(x, y) & 0xFF));
			}
		}
	}
	
	private int idx(int x, int y) {
		return y * width + x;
	}
	
	public void set(int x, int y, boolean value) {
		img.set(idx(x, y), value);
	}
	
	public void flip(int x, int y) {
		img.set(idx(x, y), !isSet(x, y));
	}
	
	public boolean isSet(int x, int y) {
		return img.get(idx(x, y));
	}
	
	public void draw() {
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				LCD.setPixel(x, y, isSet(x, y) ? 1 : 0);
			}
		}
	}
	
	public int getWidth() {return width;}
	public int getHeight() {return height;}
}
