package squirrel;

public class LiteralCharMatcher extends CharNonterminal {
    private char[] chars;
    
    public LiteralCharMatcher(String name, char[] charClass) {
        super(name);
        chars = charClass;
    }
    
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(name());
        sb.append(" ::= ");
        sb.append(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            sb.append(" | ");
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    
    public char getNthChar(int n) {return chars[n];}
    
    public int numDistinctChars() {return chars.length;}
}
