package squirrel;

abstract public class NonRecursive extends Recognizer {
    public NonRecursive(String name) {super(name);}
    
    abstract public Tree makeTree(ResultTable results, int inputStart);
    
    public boolean isTerminal() {return true;}
    
    public void verify() {}
    
    protected Error makeExhausted(Input in, int inputStart, int numMatched) {
        return new Error(name(), in, inputStart, numMatched, "Input exhausted");
    }
}
