package squirrel;
import java.util.*;

public class TokenMatcher extends TreeBuilder {
    public TokenMatcher(String name, String[][] symbols, Grammar memberOf) {
        super(name, symbols, memberOf);
    }
    
    public Tree makeFinalTree(ArrayList<Tree> symbolTrees, ResultTable results, int inputStart, int charsMatched) {
        for (Tree t: symbolTrees) {
            if (t.isError()) {
                return super.makeFinalTree(symbolTrees, results, inputStart, charsMatched);
            }
        }
        return new Leaf(name(), results.getInput(), inputStart, charsMatched);
    }
}
