package squirrel;
import java.util.*;

public class TreeBuilder extends RecursiveNonterminal {
    
    public TreeBuilder(String name, String[][] symbols, Grammar memberOf) {
        super(name, symbols, memberOf);
    }
    
    public Tree makeFinalTree(ArrayList<Tree> symbolTrees, ResultTable results, int inputStart, int charsMatched) {
        Interior result = new Interior(name(), results.getInput(), 
                                       inputStart, charsMatched, symbolTrees);
        return isLeftAssociative() ? result.getLeftRotated() : result;
    }
}
