import java.util.ArrayList;
import javax.swing.JLabel;

import squirrel.SymbolInfo;

public class GrammarNode extends JLabel {
	private ArrayList<GrammarNode> children;
	private SymbolInfo symb;
	private GrammarNode parent;
	private String name;
	
	public GrammarNode(SymbolInfo s) {
		super(s.toString());
		this.children = new ArrayList<GrammarNode>();
		this.symb = s;
		this.name = s.toString();
	}
	
	public GrammarNode(String s) {
		super(s.toString());
		this.children = new ArrayList<GrammarNode>();
		this.symb = null;
		this.name = s;
	}
	
	public void setParent(GrammarNode gn) {
		parent = gn;
	}
	
	public SymbolInfo getSymbolInfo() {
		return symb;
	}

	public GrammarNode getParentNode() {
		return parent;
	}
	
	public void addChild(GrammarNode g) {
		children.add(g);
	}
	
	public ArrayList<GrammarNode> getChildren() {
		return children;
	}
	
	public String getName() {
		return name;
	}
}
