import java.util.ArrayList;
import java.util.HashMap;

import squirrel.Tree;

public class TreeDisplay {
	private HashMap<Integer, ArrayList<TreeNode>> data;
	
	public TreeDisplay(Tree spt) {
		data = new HashMap<Integer, ArrayList<TreeNode>>();
		ArrayList<TreeNode> temp = new ArrayList<TreeNode>();
		TreeNode root = new TreeNode(spt);
		temp.add(root);
		data.put(0, temp);
	}
	
	/**
	 * pre: a valid parse tree exists
	 * 
	 * post: every node in the tree is organized according to its depth in the tree and 
	 * assigned a parent
	 */
	public void makeDisplayTree(Tree spt, int d, TreeNode parent) {
		for (int i = 0; i < spt.numChildren(); i++) {
			Tree temp = spt.nthChild(i);

			if (data.get(d) == null) {
				data.put(d, new ArrayList<TreeNode>());
			}
			TreeNode entry = new TreeNode(temp);
			entry.setParent(parent);
			data.get(d).add(entry);
			if (!temp.isLeaf()) {
				makeDisplayTree(temp, d + 1, entry);
			}
			else {
				makeDisplayTree(temp, d, parent);
			}
		}
	}
	
	public TreeNode firstEntry() {
		return data.get(0).get(0);
	}

	
	public HashMap<Integer, ArrayList<TreeNode>> getData() {
		return data;
	}
}
