import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JLabel;


public class TreeNode extends JLabel {
	private squirrel.Tree tree;
	private TreeNode parent;
	private int xPos, yPos;
	private Font font;
	private boolean folded;
	private boolean foldedRoot;
	
	public TreeNode(squirrel.Tree spt) {
		super(spt.name());
		if (spt.isError()) {
			setText("Error");
			setToolTipText(spt.errorMessage().split("\n")[0]);
		}
		folded = false;
		foldedRoot = false;
		tree = spt;
		font = new Font("Ariel", Font.PLAIN, 12);
		setFont(font);
		setBorder(BorderFactory.createEtchedBorder());
		if (!spt.isError())
		setToolTipText(spt.name());
	}
	
	public squirrel.Tree getTree() {
		return tree;
	}
	
	public int getX() {
		return xPos;
	}
	
	public int getY() {
		return yPos;
	}
	
	public void setX(int x) {
		xPos = x;
	}
	
	public void setY(int y) {
		yPos = y;
	}
	
	public void setFont(Font f) {
		font = f;
	}
		
	public Font getFont() {
		return font;
	}
	
	public Dimension getPreferredSize() {
		return new Dimension(getFontMetrics(font).getHeight(), getFontMetrics(font).stringWidth(getText()));
	}
	
	public Point getBottomCenter() {
		return new Point(getX() + getBounds().width / 2, getY() + getBounds().height);
	}
	
	public Point getTopCenter() {
		return new Point(getX() + getBounds().width / 2, getBounds().y);
	}
	
	public void setPosition(int x, int y, int w, int h) {
		setBounds(x, y, w, h);
	}
	
	public void setParent(TreeNode spt) {
		parent = spt;
	}
	
	
	public TreeNode getParentTree() {
		return parent;
	}

	public void toggleText() {
		if (tree.isError()) {
			if (getText().equals("Error")) {
				setText(getTree().errorMessage());
			}
			else {
				setText("Error");
			}
		}
		else {
			if (getText().equals(getTree().name())) {
				try {
					setText(getTree().toString());
					setToolTipText(getTree().toString());
				}
				catch (StringIndexOutOfBoundsException e) {
					System.out.println(e);
				}
			}
			else {
				setText(getTree().name());
				setToolTipText(getTree().name());
			}
		}
	}

	public void setFoldedRoot(boolean b) {
		foldedRoot = b;
	}

	public boolean isFolded() {
		return folded;
	}

	public boolean isFoldedRoot() {
		return foldedRoot;
	}

	public void setFolded(boolean b) {
		folded = b;
	}
}
