package grammars;

import squirrel.*;
import java.io.IOException;

public class StringLiteralGrammar implements HasGrammar {
    private Grammar g;
    
    public StringLiteralGrammar() {
        g = new Grammar();
        g.addToken("<string>", "<quote> [<stringChars>] <quote>");
        g.addToken("<stringChars>", "<notQuote> [<stringChars>]");
        g.addCharClass("<quote>", '"');
        g.addToken("<notQuote>", "<backslashed>", "!<quote> <any>");
        
        g.addCharClass("<backslash>", '\\');
        g.addToken("<backslashed>", "<backslash> <any>");
    }
    
    public Grammar getGrammar() {return g;}
}
