package squirrel;

public class AnyChar extends NonRecursive {
    public AnyChar() {
        super("<any>");
    }
    
    public Tree makeTree(ResultTable results, int inputStart) {
        if (results.getInput().legal(inputStart)) {
            return new Leaf(name(), results.getInput(), inputStart, 1);
        } else {
            return makeExhausted(results.getInput(), inputStart, 0);
        }
    }
    
    public int numRows() {return 1;}
    
    public int numSymbols(int row) {
        return 1;
    }
    
    public SymbolInfo symbolAt(int row, int rowPosition) {
        return new SymbolInfo(name(), true);
    }
}
