package squirrel;
import java.util.*;

abstract public class CharNonterminal extends NonRecursive {
    public CharNonterminal(String name) {
        super(name);
    }
    
    public Tree makeTree(ResultTable results, int inputStart) {
        if (results.getInput().legal(inputStart)) {
            char c = results.getInput().charAt(inputStart);
            int row = rowMatching(c);
            if (row < 0) {
                return new Error(name(), results.getInput(), inputStart, 0, getErrorMsg(c));
            } else {
                return new Leaf(name(), results.getInput(), inputStart, 1);
            } 
        } else {
            return makeExhausted(results.getInput(), inputStart, 0);
        }
    }
    
    public String getErrorMsg(char mismatch) {
        return "Character '" + mismatch + "' does not match " + matchableCharList();
    }
    
    /*[return := list of matchable characters]*/
    public String matchableCharList() {
        if (numDistinctChars() == 1) {
            return Character.toString(getNthChar(0));
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < numDistinctChars() - 1; ++i) {
                sb.append("'" + getNthChar(i) + "', ");
            }
            sb.append("or '"+ getNthChar(numDistinctChars() - 1) + "'");
            return sb.toString();
        }
    }
    
    public int numRows() {return numDistinctChars();}
    
    public int numSymbols(int row) {
        return 1;
    }
    
    public SymbolInfo symbolAt(int row, int rowPosition) {
        return new SymbolInfo(Character.toString(getNthChar(row)), true);
    }
    
    abstract public int numDistinctChars();
    
    /*[0 <= n < numDistinctChars() => return := the nth char according to the ordering of this]*/
    abstract public char getNthChar(int n);
    
    public boolean recognizesChar(char c) {return rowMatching(c) >= 0;}
    
    /*[getNthChar(n) == c => return := n | true => return := -1]*/
    public int rowMatching(char c) {
        for (int i = 0; i < numDistinctChars(); ++i) {
            if (getNthChar(i) == c) {
                return i;
            }
        }
        return -1;
    }
}
