package squirrel;
import java.util.*;

public class Error extends Tree {
    private String msg;
    private int lineNumber;
    
    public Error(String name, Input in, int start, int length, String message) {
        super(name, in, start, length);
        msg = message;
        lineNumber = (start < in.length()) ? in.lineNumberAt(start) : 0;
    }
    
    public Error(String name, Error childError) {
        this(name, childError.input(), childError.start(), childError.length(), childError.msg);
    }
    
    public boolean isError() {return true;}
    
    public String errorMessage() {
        if (input().length() == 0) {
            return "Parse error: No input";
        }
        
        StringBuilder sb = new StringBuilder();
        sb.append("Parse error in line ");
        sb.append(lineNumber);
        sb.append(": ");
        sb.append(msg);
        sb.append('\n');
        
        if (input().legal(start())) {
            int first = input().startOfLine(start());
            int last = input().endOfLine(start());
            for (int i = first; i <= last; ++i) {
                sb.append(input().charAt(i));
            }
            if (!input().endsLine(last)) {sb.append('\n');}
            for (int i = first; i <= end(); ++i) {
                sb.append(' ');
            }
            sb.append("^\n");
        }
        
        return sb.toString();
    }
    
    protected void appendTreeNodeStr(StringBuilder sb) {
        sb.append(name());
        sb.append(": \"");
        sb.append(errorMessage());
        sb.append('"');
    }
}
