package squirrel;

public class RangeCharMatcher extends CharNonterminal {
    private char low, high;
    
    /*[lo <= hi => getNthChar(0), getNthChar(hi - lo) := lo, hi
      | true => throws := IllegalArgumentException]*/
    public RangeCharMatcher(String name, char lo, char hi) {
        super(name);
        if (lo > hi) {
            throw new IllegalArgumentException(lo + " is higher than " + hi);
        }
        low = lo;
        high = hi;
    }
    
    public int numDistinctChars() {
        return high - low + 1;
    }
    
    public int rowMatching(char c) {
        int result = c - low;
        if (result < numDistinctChars() && result >= 0) {
            return result;
        } else {
            return -1;
        }
    }
    
    public char getNthChar(int n) {
        return (char)(low + n);
    }
    
    public String toString() {
        return name() + " ::= {" + low + " to " + high + "}";
    }
}
