package squirrel;

abstract public class Recognizer {
    private String name;
    
    /*[name() := name]*/
    public Recognizer(String name) {
        this.name = name;
    }
    
    public String name() {return name;}
    
    abstract public boolean isTerminal();
    
    abstract public int numRows();
    
    abstract public int numSymbols(int row);
    
    abstract public SymbolInfo symbolAt(int row, int rowPosition);
    
    /*[this is not internally consistent => throws := exception 
      | true => I]*/
    abstract public void verify();
}
