package squirrel;

public class SymbolInfo {
    private String symbol, original;
    private boolean optional;
    private boolean terminal;
    private boolean inclLook;
    private boolean exclLook;
    
    private SymbolInfo() {
        optional = terminal = inclLook = exclLook = false;
    }
    
    public SymbolInfo(String symbolName) {
        this(symbolName, false);
    }
    
    /*[getOriginal(), isOptional(), isTerminal(), isInclusiveLookahead(), isExclusiveLookahead() := 
       symbolName, squareBracketed(symbolName), not angleBracketed(symbolName), prefixedBy(symbolName, &), prefixedBy(symbolName, !)]*/
    public SymbolInfo(String symbolName, boolean ignoreSpecial) {
        this();
        symbol = original = symbolName;
        if (ignoreSpecial) {return;}
        
        if (symbol.charAt(0) == '[' && symbol.charAt(symbol.length() - 1) == ']') {
            optional = true;
            symbol = symbol.substring(1, symbol.length() - 1);
        }
        
        if (symbol.charAt(0) == '&') {
            inclLook = true;
        } else if (symbol.charAt(0) == '!') {
            exclLook = true;
        }
        
        if (inclLook || exclLook) {
            symbol = symbol.substring(1, symbol.length());
        }
        
        if (symbol.length() == 0) {
            throw new IllegalArgumentException("Zero-length symbol \"" + symbolName + "\"");
        }
        
        if (symbol.charAt(0) != '<' || symbol.charAt(symbol.length() - 1) != '>') {
            terminal = true;
        }
    }
    
    public String toString() {return symbol;}
    public String getOriginal() {return original;}
    public boolean isTerminal() {return terminal;}
    public boolean isOptional() {return optional;}
    public boolean isInclusiveLookahead() {return inclLook;}
    public boolean isExclusiveLookahead() {return exclLook;}
    public boolean isLookahead() {return inclLook || exclLook;}
}
